--========================================================--
-- Unseasonal Weather - OnDeviceText listener (client)
-- Detects real listening on the UW channel (92.7 MHz).
--========================================================--

if not UW_RF then UW_RF = {} end

local UW_RF_FREQ = 92700

local function UW_RF_OnDeviceText(guid, codes, x, y, z, text, device)
    if not device then return end
    local data = device.getDeviceData and device:getDeviceData()
    if not data then return end
    if data:getIsTurnedOn() ~= true then return end
    if data:getChannel() ~= UW_RF_FREQ then return end

    print("[UW_RF][OnDeviceText] Heard on 92.7 MHz: " .. tostring(text))

    -- Flag that the UW channel was actually heard; used for future logic.
    UW_RF.lastHeard = {
        text = text,
        x = x, y = y, z = z,
        time = getGameTime() and getGameTime():getWorldAgeHours() or nil,
    }

    if SandboxVars and SandboxVars.UW_RadioForecasting and SandboxVars.UW_RadioForecasting.DebugLogging then
        print("[UW_RF] OnDeviceText heard on 92.7 MHz: " .. tostring(text))
    end
end

Events.OnDeviceText.Add(UW_RF_OnDeviceText)
